package executorServices;

import chapter8.TakeABreak;
import java.util.concurrent.Callable;

public class ExampleCallable implements Callable<String> {
    int[] numbers;//array to process
    int pos=0;//current position in the array
    int sum=0;//attempt at calculating a result - declare sum
    
    
    public ExampleCallable(int... numbers){
        this.numbers=numbers;
    }
    
    @Override
    public String call() throws Exception {
        while (pos<numbers.length){
            processData();
            TakeABreak.sleep();
        }
        return "Sum: "+sum;
    }
    
    private synchronized void processData(){
        //check to make sure that we haven't reached the end.
        if (pos>=numbers.length) return;
        System.out.println("Number: "+numbers[pos] //Print out i
                                   +" Processed by: "
                                   +Thread.currentThread().getName());
        sum+=numbers[pos];//calculate the total
        pos++;//Explicity increment i
    }
}
